#!/usr/bin/perl

use MIME::Base64;


# This little trick should always find the optixdecrypt executable, as long as
# it's in the same directory as this util.
my ($dir, $file) = $0 =~ m|^(.*)/(.*)|;
$optixdecrypt = "$dir/optixdecrypt";


sub check_version {
  my ($exe, $supported_ver) = @_;
  my $data;

  seek ($exe, $supported{$supported_ver}{version_offset}, 0);
  read (EXE, $data, length ($supported{$supported_ver}{version_string}));
  if ($data eq $supported{$supported_ver}{version_string}) {
    return $supported_ver;
  } else {
    return
  }
}


#undef $/;
#$config = <>;
open (EXE, shift);

%supported = (
  '1.32' => {
    version_string    => 'qtcELMWvswwvn+LVMxjJ',
    version_offset    => 0x4d7b0,
    config_offset     => 0xc8000,
    config_seperators => ['*', '^', '#']
  },
  '1.33' => {
    version_string    => 'qtcELMWvswwvn+LVMxjI',
    version_offset    => 0x4cc9c,
    config_offset     => 0xb1800,
    config_seperators => [chr 0xfd, chr 0xfc, chr 0xfb]
  }
);

@tf = qw (Off On);	# True/False labels

@name = (
  ['Start Directory', ['Windows Directory', 'System Directory']],
  'Server Filename',
  'Unused?',
  'S7 Special Method Filename',
  ['Melt Server', [@tf]],
  ['Registry - Run', [@tf]],
  ['Registry - RunServices (2k/XP)', [@tf]],
  ['win.ini', [@tf]],
  ['system.ini', [@tf]],
  ['S7 Special Method', [@tf]],
  'Registry Run Key',
  'ICQ Notification',
  'CGI Notification',
  'MSN Notification',
  'IRC Notification',
  'PHP Notification',
  'SMTP Notification',
  'Specific/Custom .EXEs To Kill',
  'Specific/Custom NT/2k/XP Services To Kill',
  'Firewall .EXEs To Kill',
  'Antivirus .EXEs To Kill',
  'ID Name',
  ['Use Server Password?', [@tf]],
  'Server Port',
  'Server Password',
  'Start Notification Character',
  'End Notification Character',
  'Notification String Format',
  ['Use Fake Error?', [@tf]],
  'Fake Error Message',
  'Unused?',
  'Firewall & Antivirus .EXEs To Kill',
  'Firewall Services To Kill',
  'Antivirus Services To Kill',
  'Firewall & Antivirus Services To Kill',
  'IP Seperator'
);

for $ver (keys %supported) {
  $version = check_version (*EXE, $ver);
  last if $version;
}

die "Unknown Optix Pro version!\n" unless $version;
print "Optix Pro v$version\n\n";

seek (EXE, $supported{$version}{config_offset}, 0);

while (<EXE>) {
  $encrypted_data .= decode_base64 $_;
}

close (EXE);


my $pid = open (DECRYPTED, "-|");
if ($pid) {	# parent
  chomp ($config = <DECRYPTED>);
  close (DECRYPTED);
} else {	# child
  open (OPTIXDECRYPT, "| $optixdecrypt");
  print OPTIXDECRYPT $encrypted_data;
  close (OPTIXDECRYPT);
}

@sep = @{$supported{$version}{config_seperators}};
@a = split /\Q$sep[0]\E/, $config;

my $section = 0;
my $array;
$" = "<->";

for $a (@a) {
  #print $name[$section] ? $name[$section] : '*UNKNOWN*', " [$section]\n";
  $array = 0;
  if ($name[$section]) {
    if (ref $name[$section] eq 'ARRAY') {
      $sectionname = ${name[$section]}[0], "\n";
      $array = 1;
    } else {
      $sectionname = "$name[$section]";
    }
  } else {
    $sectionname = "*UNKNOWN*";
  }
  print "--- Section Begin: $sectionname ---\n";
  @b = split /\Q$sep[1]\E/, $a;
  for $b (@b) {
    @c = split /\Q$sep[2]\E/, $b;
    if ($array) {
      print ${${name[$section]}[1]}[$c[0]], "\n";
    } else {
      print "@c\n";
    }
  }
  print "--- Section End: $sectionname ---\n";
  $section++;
}
